<?php $data_position = get_sub_field('data_position');
if (get_sub_field('contact_title')) { ?>
	<h3 class="page-title text-left"><?php the_sub_field('contact_title'); ?></h3>
<?php }
if (get_sub_field('contact_text')) { ?>
	<?php the_sub_field('contact_text'); ?>
<?php } ?>

<?php if( have_rows('contact_datas') ): ?>
	<div class="contact-box row marginbottom">
		<?php while ( have_rows('contact_datas') ) : the_row(); ?>
			<?php if ($data_position == 'horizontal') { ?>
				<div class="col-sm-8 col-xs-24 horizontal-contact">
			<?php } else { ?>
				<div class="col-sm-24 marginbottom vertical-contact">
			<?php } ?>
				<?php 
				$contact_data = get_sub_field('contact_data');
				$contact_data_lines = explode("\n", $contact_data);
				if ( !empty($contact_data_lines) ) { ?>
					<?php if (get_sub_field('contact_type') == 'other' and get_sub_field('icon')) { ?>
						<?php the_sub_field('icon'); ?>
					<?php } else { ?>
						<i class="fa fa-<?php if (get_sub_field('contact_type') == 'address') echo 'map-marker'; elseif (get_sub_field('contact_type') == 'mail') echo 'envelope'; else the_sub_field('contact_type'); ?>" aria-hidden="true"></i>
					<?php } ?>
				
					<?php foreach ( $contact_data_lines as $line ) { ?>
						<?php if (get_sub_field('contact_type') == 'phone') { ?>
							<a href="tel:<?php echo str_replace('<br/>', '', str_replace(' ', '', trim($line))); ?>">
						<?php } elseif (get_sub_field('contact_type') == 'mail') { ?>
							<a href="mailto:<?php echo str_replace('<br/>', '', str_replace(' ', '', trim($line))); ?>">
						<?php } ?>
						<?php echo '<span>'.trim($line).'</span>'; ?>
						<?php if (get_sub_field('contact_type') == 'mail' or get_sub_field('contact_type') == 'phone') { ?>
							</a>
						<?php }
					}
				} ?>
			</div>
		<?php endwhile; ?>
	</div>
<?php endif; ?>

<?php if( have_rows('contact_departments') ): ?>
	<div class="contact-departments marginbottom">
		<?php while ( have_rows('contact_departments') ) : the_row(); ?>
			<?php if (get_sub_field('contact_department')) { ?>
				<h4><?php the_sub_field('contact_department'); ?></h4>
			<?php } ?>
			<?php if (get_sub_field('contact_department_text')) { ?>
				<?php the_sub_field('contact_department_text'); ?>
			<?php } ?>
			<?php if( have_rows('contact_people') ): ?>
				<div class="row contact-people">
					<?php while ( have_rows('contact_people') ) : the_row();
						$contact_photo = get_sub_field('photo'); ?>
						<?php if ($contact_photo) { ?>
							<div class="col-sm-6">
								<img src="<?php echo $contact_photo['sizes']['medium']; ?>" alt="<?php echo $contact_photo['alt']; ?>">
							</div>
							<div class="col-sm-18">
						<?php } else { ?>
							<div class="col-sm-24">
						<?php } ?>
								<?php if (get_sub_field('name')) { ?>
									<h5><?php the_sub_field('name'); ?></h5>
								<?php } ?>
								<?php if (get_sub_field('position')) { ?>
									<p><em><?php the_sub_field('position'); ?></em></p>
								<?php } ?>
								<?php if (get_sub_field('data')) { ?>
									<?php the_sub_field('data'); ?>
								<?php } ?>
							</div>
					<?php endwhile; ?>
				</div>
			<?php endif; ?>
		<?php endwhile; ?>
	</div>
<?php endif; ?>

<?php if (get_sub_field('additional_text')) { ?>
	<?php the_sub_field('additional_text'); ?>
<?php } ?>

<?php if (get_sub_field('show_social') and have_rows('social_link','option') ): ?>
	<div class="social-icons margintop">
		<?php while ( have_rows('social_link','option') ) : the_row();
			if (get_sub_field('link')) { ?>
				<a href="<?php the_sub_field('link'); ?>" target="_blank" class="social-<?php the_sub_field('social_service'); ?>">
					<?php if (get_sub_field('show_service_name') and get_sub_field('service_name')) { ?>
						<?php the_sub_field('service_name'); ?>
					<?php } else { ?>
						<i class="fa <?php if (get_sub_field('social_service') == 'other') the_sub_field('service_icon'); elseif (get_sub_field('social_service') == 'youtube') echo 'fa-' . get_sub_field('social_service') . '-play'; else echo 'fa-' . get_sub_field('social_service'); ?>"aria-hidden="true"<?php if (get_sub_field('service_color')) { ?> style="color: <?php the_sub_field('service_color'); ?>;"<?php } ?>></i>
					<?php } ?>
				</a>
			<?php }
		endwhile; ?>
	</div>
<?php endif; ?>